string GetDescription()
{
	return "Renders the harmony into a track with simple chords ( tonic, quint and octave )";
}

bool[] GenerateAccents(RenderPart @p, double speed, bool first )
{
	int count = (p.GetUniquePart().GetMetrum() / speed);	
	
	bool[] accents(count);
	
	for (int i = 0; i < count; i++) 
	{
		if (first && i == 0) accents[i] = true;
		else 
		{
			if (i > 0 && accents[i-1]) 
			{
				accents[i] = false;	
			}
			else
			{
				if (RndInt(0,1) == 0) accents[i] = true;	
				else accents[i] = false;	
			}
		}
	}
	
	return accents;
}

int last_harm;
int low_pit;

int abs(int val)
{
	if (val < 0) return -val;
	return val;
}

void PlacePunkChord(RenderPart @p, Time t, Time t2, int vel, int harm, bool accent, int swap_down)
{
	int[] pit(3);
	
	pit[0] = p.GetHarmonicEventPitch(harm,0);
	pit[1] = p.AlignPitch(p.GetHarmonicEventPitch(harm,0),4);
	pit[2] = p.AlignPitch(p.GetHarmonicEventPitch(harm,0),7) ;
	
	if (last_harm < -100)
	{
		last_harm = harm;
		low_pit = pit[0]+RndInt(-4,10);
	}
	
	if (last_harm != harm)
	{
		last_harm = harm;
		low_pit = pit[0] + RndInt(-3,5);
	}
	
	while (pit[0] > low_pit)
	{
		int odl = pit[0] - low_pit;
		
		if (odl >= abs(low_pit - (pit[1]-12)))
		{
			
			int tmp = pit[2];
			pit[2] = pit[1];
			pit[1] = tmp;
					
			tmp = pit[1];
			pit[1] = pit[0];
			pit[0] = tmp;
			
			pit[0] = pit[2]-12;
		}
		else break;
	}
	
	int odl = pit[1] - pit[0];
	if (odl != 6)
	{
		if (swap_down == 1)
		{
			p.AddNote(t, t2, pit[0],vel);		
			p.AddNote(t, t2, pit[1]-12,vel);		
			p.AddNote(t, t2, pit[1],vel);		
		}
		else
		{
			p.AddNote(t, t2, pit[0],vel);		
			p.AddNote(t, t2, pit[1],vel);		
			p.AddNote(t, t2, pit[2],vel);		
	
			if (RndInt(0,1) == 0 && accent) p.AddNote(t, t2, pit[1] + 12,vel);		
		}
	}
	else
	{
		if (accent)
		{
			p.AddNote(t, t2, p.GetHarmonicEventPitch(harm,0),vel);	
			p.AddNote(t, t2, p.AlignPitch(p.GetHarmonicEventPitch(harm,0),4)-12,vel/3);	
			p.AddNote(t, t2, p.GetHarmonicEventPitch(harm,0)-12,vel);
		}
		else
		{
			p.AddNote(t, t2, p.GetHarmonicEventPitch(harm,0),vel);	
			p.AddNote(t, t2, p.GetHarmonicEventPitch(harm,0)-12,vel);		
		}
	}
		
}

void DoMode1(RenderPart @p)
{
	Time t = CreateTime(p.GetStartBar(), 0);
	
	double speed = 0.5;
	
	if (p.GetTempo() < 110) speed /= 2.0;
	
	int wyprz = RndInt(0,2);
	int speed_up = RndInt(0,1);
	
	int reset = 8;
	if (RndInt(0,1) == 0) reset = 4;
		
	ResetSeed();	
	bool[] accents = GenerateAccents(p, speed, true );
	
	int reset_counter = 0;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		Time t = CreateTime(i, 0);
		
		for (uint a = 0; a < accents.length(); a++)
		{
			int harm = p.GetHarmonic(t);
			
			if (wyprz > 0 && a == accents.length()-1)
			{
				if (wyprz == 1 || (wyprz == 2 && RndInt(0,1) == 0))
					harm = p.GetHarmonic(CreateTime(t.m_Bar+1, 0));
			}
			
			Time t2;
			int vel = 88;
			if (accents[a]) 
			{
				t2 = CreateTime(t.m_Bar, t.m_Pos + 0.8 * speed);
				vel = 116;
			}
			else t2 = CreateTime(t.m_Bar, t.m_Pos + speed * 0.4);
			
			PlacePunkChord(p, t, t2, vel, harm, accents[a],0);
			
			if (speed_up > 0 && !accents[a] && a == accents.length()-1 )
			{
				PlacePunkChord(p, CreateTime(t.m_Bar, t.m_Pos+speed/2.0),CreateTime(t2.m_Bar, t2.m_Pos+speed*0.4), vel, harm, accents[a],0);
			}
			
			t.m_Pos += speed;
		}
		
		reset_counter++;
		if (reset_counter >= reset)
		{
			reset_counter = 0;
			ResetSeed();	
			last_harm = -1000;
			accents = GenerateAccents(p, speed, true );
		}
		else
		{
			accents = GenerateAccents(p, speed, false );
		}
	}
}

void DoMode2(RenderPart @p)
{
	double step = 2;
	if (p.GetUniquePart().GetMetrum() == 3) 
	{
		step = 2;
		if (p.GetTempo() < 120) step /= 2.0;
	}
	else
	{
		if (p.GetTempo() < 110) step /= 2.0;
	}
	
	int swap_down = RndInt(0,1);
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m + step*0.9 < p.GetUniquePart().GetMetrum(); m+=step)
		{
			Time t = CreateTime(i, m);
			int harm = p.GetHarmonic(t);
			
			if (RndInt(0,2) != 0)
				PlacePunkChord(p, t, CreateTime(i, m+step/2.0), 120, harm, true, swap_down);
			else
			{
				PlacePunkChord(p, t, CreateTime(i, m+step/4.0), 120, harm, true, swap_down);
				PlacePunkChord(p, CreateTime(i, m+step/4.0), CreateTime(i, m+step/2.0), 120, harm, true, swap_down);
			}
			
			PlacePunkChord(p, CreateTime(i, m+step/2.0), CreateTime(i, m+step/2.0+0.1), 88, harm, false, swap_down);
			
			if ((i !=  p.GetStartBar() || m > 0)  && RndInt(0,4) != 0)
			{
				if (RndInt(0,1) == 0) 
				{
					if (m > 0) harm = p.GetHarmonic(CreateTime(i,m-0.1));
					else harm = p.GetHarmonic(CreateTime(i-1,p.GetUniquePart().GetMetrum()-step/4.0+m));
				}
				
				if (RndInt(0,3) != 0)
				{
					PlacePunkChord(p, CreateTime(i-1,p.GetUniquePart().GetMetrum()-step/4.0+m), t, 120, harm, true, swap_down);	
				}	
				else
				{
					PlacePunkChord(p, CreateTime(i-1,p.GetUniquePart().GetMetrum()-step/4.0+m), CreateTime(i-1,p.GetUniquePart().GetMetrum()-step/4.0+0.1+m) , 88, harm, false, swap_down);	
					PlacePunkChord(p, CreateTime(i-1,p.GetUniquePart().GetMetrum()-step/8.0+m), CreateTime(i-1,p.GetUniquePart().GetMetrum()-step/8.0+0.1+m) , 88, harm, false, swap_down);	
				}
				
			}
			
			if (swap_down == 0) swap_down = 1;
			else swap_down = 0;
		}
	}
}

void DoMode3(RenderPart @p)
{
	double step = 1.0;
	if (p.GetTempo() < 140) step /= 2.0;
	if (p.GetTempo() < 60) step /= 2.0;
	
	Time t = CreateTime(p.GetStartBar(), 0);
	
	int[] swap_down = { RndInt(0,1), RndInt(0,1) };
	bool[] accent = { false, false };
		
	if (RndInt(0,1) == 0) accent[0] = true;
	if (RndInt(0,1) == 0) accent[1] = true;
	
	if (RndInt(0,2) != 0)
	{
		accent[0] = false;
		accent[1] = false;
		swap_down[0] = 0;
		swap_down[1] = 0;
	}
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{
			int harm = p.GetHarmonic(CreateTime(i,m));
			if (RndInt(0,3) != 0 || ( m < 0.1 && RndInt(0,1) == 0))
			{
				PlacePunkChord(p, CreateTime(i,m), CreateTime(i,m+step) , 125, harm, accent[0], swap_down[0]);	
			}
			else
			{
				PlacePunkChord(p, CreateTime(i,m), CreateTime(i,m+step/2) , 120, harm, accent[1], swap_down[1]);	
				PlacePunkChord(p, CreateTime(i,m+step/2), CreateTime(i,m+step) , 120, harm, accent[1], swap_down[1]);	
			}		
		}
	}
}

void Render(RenderPart @p)
{
	int mode = p.GetParam("mode").toInt();
	if (mode == 0) mode = RndInt(0,2);
	else mode --;
	
	last_harm = -1000;
	if (mode == 0) DoMode1(p);
	if (mode == 1) DoMode2(p);
	if (mode == 2) DoMode3(p);
}